#ifndef SD_H
#define SD_H

/* 

	Suitable for PIC18 devices, modified from original by Mauro Grassi, 2010.

*/

#include "GenericTypeDefs.h"
#include "ff.h"

#define DEBUG_SD_INIT				0
#define USE_CRC_ON_COMMANDS			0
#define USE_CRC_ON_DATA				0

#define ERROR_ALL_OK			  	0x00
#define ERROR_NOT_SDMMC_CARD		0x01
#define ERROR_BAD_VOLTAGE_RANGE	  	0x02
#define ERROR_SDMMC_CARD_TIMEOUT	0x04
#define ERROR_CLOSED_CARD			0x10

#define USE_SD_REGISTERS    		1 

/* Number of tries to wait for the card to go idle during initialization */

#define SDMMC_IDLE_WAIT_MAX			900
#define SDMMC_READ_TIMEOUT  		32000
#define SDMMC_WRITE_TIMEOUT			32000
#define SDMMC_CMD_TIMEOUT 			900

typedef unsigned int 				TIMEOUT_TYPE;

#define R1 							1
#define R1B 						2
#define R2 							3
#define R3 							4
#define R1X18						5
#define R2X64						6
#define R7							7

/******************************** Basic command set **************************/
/* Reset cards to idle state */
#define CMD0 0
#define CMD0_R R1
/* Read the OCR (MMC mode, do not use for SD cards) */
#define CMD1 1
#define CMD1_R R1
/* Card sends the CSD */
#define CMD8 8
#define CMD8_R R7
//
#define CMD9 9
#define CMD9_R R1X18
/* Card sends CID */
#define CMD10 10
#define CMD10_R R1X18
/* Stop a multiple block (stream) read/write operation */
#define CMD12 12
#define CMD12_R R1B
/* Get the addressed card's status register */
#define CMD13 13
#define CMD13_R R2
/***************************** Block read commands **************************/
/* Set the block length */
#define CMD16 16
#define CMD16_R R1
/* Read a single block */
#define CMD17 17
#define CMD17_R R1
/* Read multiple blocks until a CMD12 */
#define CMD18 18
#define CMD18_R R1
/***************************** Block write commands *************************/
/* Write a block of the size selected with CMD16 */
#define CMD24 24
#define CMD24_R R1
/* Multiple block write until a CMD12 */
#define CMD25 25
#define CMD25_R R1
/* Program the programmable bits of the CSD */
#define CMD27 27
#define CMD27_R R1
/***************************** Write protection *****************************/
/* Set the write protection bit of the addressed group */
#define CMD28 28
#define CMD28_R R1B
/* Clear the write protection bit of the addressed group */
#define CMD29 29
#define CMD29_R R1B
/* Ask the card for the status of the write protection bits */
#define CMD30 30
#define CMD30_R R1
/***************************** Erase commands *******************************/
/* Set the address of the first write block to be erased */
#define CMD32 32
#define CMD32_R R1
/* Set the address of the last write block to be erased */
#define CMD33 33
#define CMD33_R R1
/* Erase the selected write blocks */
#define CMD38 38
#define CMD38_R R1B
/***************************** Lock Card commands ***************************/
/* Commands from 42 to 54, not defined here */
/***************************** Application-specific commands ****************/
/* Flag that the next command is application-specific */
#define CMD55 55
#define CMD55_R R1
/* General purpose I/O for application-specific commands */
#define CMD56 56
#define CMD56_R R1
/* Read the OCR (SPI mode only) */
#define CMD58 58
#define CMD58_R R3
/* Turn CRC on or off */
#define CMD59 59
#define CMD59_R R1
/***************************** Application-specific commands ***************/
/* Get the SD card's status */
#define ACMD13 13
#define ACMD13_R R2X64
/* Get the number of written write blocks (Minus errors ) */
#define ACMD22 22
#define ACMD22_R R1
/* Set the number of write blocks to be pre-erased before writing */
#define ACMD23 23
#define ACMD23_R R1
/* Get the card's OCR (SD mode) */
#define ACMD41 41
#define ACMD41_R R1
/* Connect or disconnect the 50kOhm internal pull-up on CD/DAT[3] */
#define ACMD42 42
#define ACMD42_R R1
/* Get the SD configuration register */
#define ACMD51 42
#define ACMD51_R R1

typedef struct 
{
	unsigned char	TAAC;
	unsigned char	NSAC;
	unsigned char 	TRAN_SPEED;
	unsigned short	CCC;
	unsigned char	READ_BL_LEN;
	unsigned long	C_SIZE;
	unsigned char	C_SIZE_MULT;
	unsigned char	SECTOR_SIZE;
	unsigned char	FILE_FORMAT;
} CSD_REGISTER;

typedef struct
{
	unsigned char	MID;		// Manufacturer ID
	unsigned short	OID;		// OEM ID
	unsigned char 	PNM[7];		// Product Name
	unsigned char	PRV;		// Product Revision
	unsigned char	PSN[4];		// Serial Number
	unsigned short	MDT;		// Manufacture Date M/Y from 2000
} CID_REGISTER;

typedef struct
{
	unsigned char	OCR[4];
} OCR_REGISTER;

typedef struct
{
	unsigned char		CARD_TYPE;		// 0: not SD/MMC, 1: MMC , 2: SD v1 4: SD v2 6: SDHC
	unsigned char		VOLTAGE_RANGE;	// 0: not supported 1: supported (3.3V)
	unsigned long 		SIZE;			// size in Bytes (filled in when CSD is read)
	unsigned char		cERROR;			// 0: no errors >0: errors
	CID_REGISTER		cid;			// CID Register
	CSD_REGISTER		csd;			// CSD Register
	OCR_REGISTER		ocr;			// OCR Register
	unsigned short		checkCRC;		// 1: enable CRC checking...
	unsigned long		SIZEFREE;		/* current free size */
} CARD_INFO;

int sendCommandSDCardSPI(BYTE, BYTE, BYTE*, BYTE*);
unsigned int readSingleBlockSDCardSPI(CARD_INFO*, unsigned long, unsigned int, BYTE*, BYTE*);
unsigned long readMultipleBlockSDCardSPI(CARD_INFO*, unsigned long, unsigned int, BYTE*, BYTE*, unsigned int);
unsigned int writeSingleBlockSDCardSPI(CARD_INFO*, unsigned long, unsigned int, BYTE*, BYTE*);
unsigned long writeMultipleBlockSDCardSPI(CARD_INFO*, unsigned long, unsigned int, BYTE*, BYTE*, unsigned int);
int getCIDCSDRegisters(CARD_INFO*);
int InitSDMMCCardSPI(CARD_INFO*);
unsigned char* 	getMemoryCardPNM(CARD_INFO* cardInfo, unsigned char* outstr);
unsigned char* 	getMemoryCardPSN(CARD_INFO* cardInfo, unsigned char* outstr);
unsigned char* 	getMemoryCardPRV(CARD_INFO* cardInfo, unsigned char* outstr);
unsigned char* 	getMemoryCardType(CARD_INFO* cardInfo, unsigned char* outstr);
unsigned char* 	getMemoryCardFreeSize(CARD_INFO* cardInfo, unsigned char* outstr);
unsigned char* 	getMemoryCardTotalSize(CARD_INFO* cardInfo, unsigned char* outstr);
FRESULT 		updateFreeSize(CARD_INFO* thisCard);
FRESULT 		initMemoryCardSystem(CARD_INFO* thisCard);

extern int				spi1con1Temp;
extern int 				spi1con2Temp;
extern int				spi1StatTemp;
extern int 				iSpeed;
extern unsigned char 	commandBuffer[6];
extern unsigned char 	receiveBuffer[20];

#endif
